<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Application extends Model
{
    protected $fillable = [
        'user_id', 'full_name', 'date_of_birth', 'gender', 'nationality', 'current_address',
        'permanent_address', 'phone', 'email', 'preferred_contact', 'has_disability',
        'disability_description', 'personal_statement', 'career_interest', 'weekly_availability', 'status'
    ];

    public function user(): BelongsTo {
        return $this->belongsTo(User::class);
    }

    public function educations(): HasMany {
        return $this->hasMany(Education::class);
    }

    public function references(): HasMany {
        return $this->hasMany(Reference::class);
    }

    public function documents(): HasMany {
        return $this->hasMany(Document::class);
    }
}
