<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('applications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('full_name');
            $table->date('date_of_birth');
            $table->string('gender');
            $table->string('nationality');
            $table->text('current_address');
            $table->text('permanent_address')->nullable();
            $table->string('phone');
            $table->string('email');
            $table->string('preferred_contact');
            $table->boolean('has_disability')->default(false);
            $table->text('disability_description')->nullable();
            $table->text('personal_statement');
            $table->string('career_interest')->nullable();
            $table->integer('weekly_availability');
            $table->string('status')->default('pending');
            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('applications');
    }
};
