<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('educations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('application_id')->constrained()->onDelete('cascade');
            $table->string('institution');
            $table->string('program');
            $table->string('degree_level');
            $table->year('graduation_year');
            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('educations');
    }
};
