<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('references', function (Blueprint $table) {
            $table->id();
            $table->foreignId('application_id')->constrained()->onDelete('cascade');
            $table->string('type'); // academic or character
            $table->string('name');
            $table->string('relationship');
            $table->string('institution');
            $table->string('email');
            $table->string('phone')->nullable();
            $table->string('letter_path');
            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('references');
    }
};
